class MSCCustomWeapon extends MarkistanGuns;

#exec TEXTURE IMPORT NAME=CustomWeaponIcon FILE=Textures\CustomWeaponIcon.PCX GROUP=Icons //Not much better to be done...

enum EWepModel
{
        WM_Undecided,
	WM_AssaultRifle,
	WM_StealthPistol,
	WM_AssaultShotgun,
	WM_Pistol,
	WM_SawedOffShotgun,
	WM_SniperRifle,
	WM_KS23,
	WM_Saiga12
};

enum EWepType
{
        WT_Undecided,
	WT_SMG,
	WT_Rifle,
	WT_Shotgun,
	WT_Handgun,
	WT_AutoShotgun,
        WT_AssaultRifle
};

var int WeaponMesh;
var bool bSpecAcc, bSpecPen, bSpecDam, bSpecScope, bSpecSilencer, bSpecKnockBack, bSpecClipSize, bSpecRecoil, bSpecRange;
var class<Ammo> CraftAmmo;
var int WeaponType;
var sound CFireSound, CSelectSound, CReloadSound, CFinishReloadSound;

var Vector ViewOffsets[10], FireOffsets[10];

simulated function vector CalcDrawOffset()
{
	local vector		DrawOffset, WeaponBob;
	local ScriptedPawn	SPOwner;
	local Pawn			PawnOwner;

	SPOwner = ScriptedPawn(Owner);
	if (SPOwner != None)
	{
		//DrawOffset = ((0.9/SPOwner.FOVAngle * GetCraftViewOffset() ) >> SPOwner.ViewRotation);
		DrawOffset = ((0.9/SPOwner.FOVAngle * PlayerViewOffset ) >> SPOwner.ViewRotation);
		DrawOffset += (SPOwner.BaseEyeHeight * vect(0,0,1));
	}
	else
	{
		// copied from Engine.Inventory to not be FOVAngle dependent
		PawnOwner = Pawn(Owner);
		//DrawOffset = ((0.9/PawnOwner.Default.FOVAngle * GetCraftViewOffset() ) >> PawnOwner.ViewRotation);
		DrawOffset = ((0.9/PawnOwner.Default.FOVAngle * PlayerViewOffset ) >> PawnOwner.ViewRotation);

		DrawOffset += (PawnOwner.EyeHeight * vect(0,0,1));
		WeaponBob = BobDamping * PawnOwner.WalkBob;
		WeaponBob.Z = (0.45 + 0.55 * BobDamping) * PawnOwner.WalkBob.Z;
		DrawOffset += WeaponBob;
	}

	return DrawOffset;
}

//====================================================
//Update: SON OF A BITCH! Player view offsets are
//        multiplied by 100 after the game begins
//        Very clever, inventory.uc, but your tricks
//        Shall work no more! ~WCCC
//====================================================
function Vector GetCraftViewOffset()
{
 local vector ViewOffset;
 
 if (WeaponMesh == 1) //Assault Rifle
 {
  FireOffset = FireOffsets[1];
  PlayerViewOffset = ViewOffsets[1] * 100;
 }

 if (WeaponMesh == 2) //Stealth Pistol
 {
  FireOffset = FireOffsets[2];
  PlayerViewOffset = ViewOffsets[2] * 100;
 }

 if (WeaponMesh == 3) //Assault Shotgun
 {
  FireOffset = FireOffsets[3];
  PlayerViewOffset = ViewOffsets[3] * 100;
 }

 if (WeaponMesh == 4) //Pistol
 {
  FireOffset = FireOffsets[4];
  PlayerViewOffset = ViewOffsets[4] * 100;
 }
 
 if (WeaponMesh == 5) //Sawed Off
 {
  FireOffset = FireOffsets[5];
  PlayerViewOffset = ViewOffsets[5] * 100;
 }

 if (WeaponMesh == 6) //Sniper Rifle
 {
  FireOffset = FireOffsets[6];
  PlayerViewOffset = ViewOffsets[6] * 100;
 }

 if (WeaponMesh == 7) //KS-23
 {
  FireOffset = FireOffsets[7];
  PlayerViewOffset = ViewOffsets[7] * 100;
 }

 if (WeaponMesh == 8) //Saiga 12
 {
  FireOffset = FireOffsets[8];
  PlayerViewOffset = ViewOffsets[8] * 100;
 }
 
 Default.FireSound = FireSound;
 Default.SelectSound = SelectSound;
 Default.CockingSound = CockingSound;
 Default.AltFireSound = AltFireSound;

 FireSound = FireSound;
 SelectSound = SelectSound;
 CockingSound = CockingSound;
 AltFireSound = AltFireSound;
 
 return ViewOffset;
}

simulated function EraseMuzzleFlashTexture()
{
	if (WeaponMesh == 7 || WeaponMesh == 8)
        {
	 MultiSkins[4] = Texture'BlackMaskTex';
	 MultiSkins[5] = Texture'BlackMaskTex';
	}
	if (WeaponMesh <= 6)
        {
	 MultiSkins[2] = Texture'BlackMaskTex';
	}
	
	GetCraftViewOffset();
}

function inventory SpawnCopy( pawn Other )
{
 local MSCCustomWeapon copy;

 copy = MSCCustomWeapon(Super.SpawnCopy(Other));
 copy.AmmoName = Self.AmmoName;
 copy.FireOffset = FireOffset;
 copy.PlayerViewOffset = PlayerViewOffset;
 copy.Default.FireOffset = FireOffset;
 copy.Default.PlayerViewOffset = PlayerViewOffset;
 copy.PlayerViewMesh = PlayerViewMesh;
 copy.PickupViewMesh = PickupViewMesh;
 copy.ThirdPersonMesh = ThirdPersonMesh;
 copy.Mesh = Mesh;
 copy.Texture = Texture;
 
 copy.Default.FireSound = FireSound;
 copy.Default.SelectSound = SelectSound;
 copy.Default.CockingSound = CockingSound;
 copy.Default.AltFireSound = AltFireSound;

 copy.FireSound = FireSound;
 copy.SelectSound = SelectSound;
 copy.CockingSound = CockingSound;
 copy.AltFireSound = AltFireSound;
 
 copy.PenetrationPower = PenetrationPower;
 copy.AreaOfEffect = AreaOfEffect;
 copy.BaseAccuracy = BaseAccuracy;
 copy.ReloadCount = ReloadCount;
 copy.Default.ReloadCount = ReloadCount;
 copy.LowAmmoWaterMark = LowAmmoWaterMark;
 copy.RecoilStrength = RecoilStrength;
 copy.AccurateRange = AccurateRange;
 copy.MaxRange = MaxRange;
 copy.bKnockback = bKnockback;
 copy.KnockbackAmount = KnockbackAmount;
 copy.ShotTime = ShotTime;
 copy.bAutomatic = bAutomatic;
 copy.Default.bAutomatic = bAutomatic;

 copy.ShakeMag = ShakeMag;
 copy.GoverningSkill = GoverningSkill;
 copy.HitDamage = HitDamage;
 copy.PickupAmmoCount = PickupAmmoCount;
 copy.Mass = Mass;
 copy.ReloadTime = ReloadTime;
 
 copy.AmmoNames[0] = AmmoNames[0];
 copy.AmmoNames[1] = AmmoNames[1];
 copy.ProjectileNames[1] = ProjectileNames[1];
 
 return copy;
}

function UpdateCraftProperties() //PostBeginPlay was being called too fast, so this is 
				 //now called manually.
{
 //Super.PostBeginPlay();
 
 AmmoName = CraftAmmo;
 
 FireSound = CFireSound;
 SelectSound = CSelectSound;
 CockingSound = CReloadSound;
 AltFireSound = CFinishReloadSound;

 Default.FireSound = CFireSound;
 Default.SelectSound = CSelectSound;
 Default.CockingSound = CReloadSound;
 Default.AltFireSound = CFinishReloadSound;
 
 if (WeaponType == 0 || WeaponMesh == 0)
 {
  Log("ERROR: Custom weapon spawned with null properties.");
  Destroy();
 }
 
 if (WeaponType == 1) //SMG
 {
  PenetrationPower = 24;
  AreaOfEffect = AOE_Point;
  BaseAccuracy = 0.785000;
  ReloadCount = 25;
  LowAmmoWaterMark = 25;
  RecoilStrength = 0.750000;
  AccurateRange = 1200;
  MaxRange = 1200;
  bKnockback = True;
  KnockbackAmount = 25;
  ShotTime = 0.200000;
  bAutomatic = True;
  ShakeMag = 200;
  GoverningSkill = class'SkillWeaponRifle';
  HitDamage = 6;
  PickupAmmoCount = 75;
  Mass = 30;
  ReloadTime = 2.250000;
 }
 
 if (WeaponType == 2) //Rifle
 {
  PenetrationPower = 60;
  AreaOfEffect = AOE_Point;
  BaseAccuracy = 0.250000;
  ReloadCount = 5;
  LowAmmoWaterMark = 5;
  RecoilStrength = 0.600000;
  AccurateRange = 28800;
  MaxRange = 28800;
  bKnockback = True;
  KnockbackAmount = 75;
  ShotTime = 1.200000;
  bAutomatic = False;
  ShakeMag = 200;
  GoverningSkill = class'SkillWeaponRifle';
  HitDamage = 40;
  PickupAmmoCount = 20;
  Mass = 30;
  ReloadTime = 2.750000;
 }
 
 if (WeaponType == 3) //Pump Shotgun
 {
  PenetrationPower = 35;
  AreaOfEffect = AOE_Cone;
  BaseAccuracy = 0.675000;
  ReloadCount = 4;
  LowAmmoWaterMark = 8;
  RecoilStrength = 0.500000;
  AccurateRange = 1200;
  MaxRange = 1200;
  bKnockback = True;
  KnockbackAmount = 150;
  ShotTime = 0.200000;
  bAutomatic = False;
  ShakeMag = 50;
  GoverningSkill = class'SkillWeaponRifle';
  HitDamage = 12;
  PickupAmmoCount = 24;
  Mass = 15;
  ReloadTime = 1.850000;
 }
 
 if (WeaponType == 4) //Handgun
 {
  PenetrationPower = 80;
  AreaOfEffect = AOE_Point;
  BaseAccuracy = 0.600000;
  ReloadCount = 12;
  LowAmmoWaterMark = 12;
  RecoilStrength = 0.300000;
  AccurateRange = 1200;
  MaxRange = 1200;
  bKnockback = True;
  KnockbackAmount = 80;
  ShotTime = 0.277500;
  bAutomatic = False;
  ShakeMag = 50;
  GoverningSkill = class'SkillWeaponPistol';
  HitDamage = 18;
  PickupAmmoCount = 36;
  Mass = 15;
  ReloadTime = 0.700000;
 }
 
 if (WeaponType == 5) //Auto Shotgun
 {
  PenetrationPower = 24;
  AreaOfEffect = AOE_Cone;
  BaseAccuracy = 0.800000;
  ReloadCount = 12;
  LowAmmoWaterMark = 12;
  RecoilStrength = 0.700000;
  AccurateRange = 1800;
  MaxRange = 1800;
  bKnockback = True;
  KnockbackAmount = 80;
  ShotTime = 0.700000;
  bAutomatic = True;
  ShakeMag = 50;
  GoverningSkill = class'SkillWeaponHeavy';
  HitDamage = 9;
  PickupAmmoCount = 36;
  Mass = 30;
  ReloadTime = 2.750000;
 }
 
 if (WeaponType == 6) //AssaultRifle
 {
  PenetrationPower = 16;
  AreaOfEffect = AOE_Point;
  BaseAccuracy = 0.650000;
  ReloadCount = 30;
  LowAmmoWaterMark = 30;
  RecoilStrength = 0.400000;
  AccurateRange = 2500;
  MaxRange = 2500;
  bKnockback = True;
  KnockbackAmount = 110;
  ShotTime = 0.200000;
  bAutomatic = True;
  Default.bAutomatic = True;
  ShakeMag = 50;
  AmmoNames[0] = CraftAmmo;
  AmmoNames[1] = class'Ammo20mm';
  ProjectileNames[1] = class'MSC20mmCannister';
  GoverningSkill = class'SkillWeaponRifle';
  HitDamage = 8;
  PickupAmmoCount = 90;
  Mass = 30;
  ReloadTime = 2.000000;
 }
 
 if (WeaponMesh == 1) //Assault Rifle
 {
  Default.FireOffset = FireOffsets[1];
  FireOffset = FireOffsets[1];
  PlayerViewOffset = ViewOffsets[1] * 100;
  PlayerViewMesh = LodMesh'AssaultGun';
  PickupViewMesh = LodMesh'AssaultGunPickup';
  ThirdPersonMesh = LodMesh'AssaultGun3rd';
  Mesh = LodMesh'AssaultGunPickup';
 }

 if (WeaponMesh == 2) //Stealth Pistol
 {
  Default.FireOffset = FireOffsets[2];
  FireOffset = FireOffsets[2];
  PlayerViewOffset = ViewOffsets[2] * 100;
  PlayerViewMesh = LodMesh'StealthPistol';
  PickupViewMesh = LodMesh'StealthPistolPickup';
  ThirdPersonMesh = LodMesh'StealthPistol3rd';
  Mesh = LodMesh'StealthPistolPickup';
 }

 if (WeaponMesh == 3) //Assault Shotgun
 {
  Default.FireOffset = FireOffsets[3];
  FireOffset = FireOffsets[3];
  PlayerViewOffset = ViewOffsets[3] * 100;
  PlayerViewMesh = LodMesh'AssaultShotgun';
  PickupViewMesh = LodMesh'AssaultShotgunPickup';
  ThirdPersonMesh = LodMesh'AssaultShotgun3rd';
  Mesh = LodMesh'AssaultShotgunPickup';
 }

 if (WeaponMesh == 4) //Pistol
 {
  Default.FireOffset = FireOffsets[4];
  FireOffset = FireOffsets[4];
  PlayerViewOffset = ViewOffsets[4] * 100;
  PlayerViewMesh = LodMesh'Glock';
  PickupViewMesh = LodMesh'GlockPickup';
  ThirdPersonMesh = LodMesh'Glock3rd';
  Mesh = LodMesh'GlockPickup';
 }
 
 if (WeaponMesh == 5) //Sawed Off
 {
  Default.FireOffset = FireOffsets[5];
  FireOffset = FireOffsets[5];
  PlayerViewOffset = ViewOffsets[5] * 100;
  PlayerViewMesh = LodMesh'Shotgun';
  PickupViewMesh = LodMesh'ShotgunPickup';
  ThirdPersonMesh = LodMesh'Shotgun3rd';
  Mesh = LodMesh'ShotgunPickup';
 }

 if (WeaponMesh == 6) //Sniper Rifle
 {
  Default.FireOffset = FireOffsets[6];
  FireOffset = FireOffsets[6];;
  PlayerViewOffset = ViewOffsets[6] * 100;
  PlayerViewMesh = LodMesh'SniperRifle';
  PickupViewMesh = LodMesh'SniperRiflePickup';
  ThirdPersonMesh = LodMesh'SniperRifle3rd';
  Mesh = LodMesh'SniperRiflePickup';
 }

 if (WeaponMesh == 7) //KS-23
 {
  Default.FireOffset = FireOffsets[7];
  FireOffset = FireOffsets[7];
  PlayerViewOffset = ViewOffsets[7] * 100;
  PlayerViewMesh = LodMesh'KS231st';
  PickupViewMesh = LodMesh'KS23Pickup';
  ThirdPersonMesh = LodMesh'KS233rd';
  Mesh = LodMesh'KS23Pickup';
  Texture = Texture'ReflectionMapTex2';
 }

 if (WeaponMesh == 8) //Saiga 12
 {
  Default.FireOffset = FireOffsets[8];
  FireOffset = FireOffsets[8];
  PlayerViewOffset = ViewOffsets[8] * 100;
  PlayerViewMesh = LodMesh'Saiga121st';
  PickupViewMesh = LodMesh'Saiga12Pickup';
  ThirdPersonMesh = LodMesh'Saiga123rd';
  Mesh = LodMesh'Saiga12Pickup';
  Texture = Texture'ReflectionMapTex2';
 }
 
 ApplySpecMods();
}

function ApplySpecMods()
{
 if (bSpecAcc) BaseAccuracy -= 0.180000;
 if (bSpecPen) PenetrationPower += 35;
 if (bSpecDam) hitDamage += 2;
 if (bSpecScope) bHasScope = True;
 if (bSpecSilencer) bHasSilencer = True;
 if (bSpecKnockBack) KnockbackAmount += 35;
 if (bSpecClipSize)
 {
  ReloadCount *= 1.5;
  Default.ReloadCount *= ReloadCount;
 }
 if (bSpecRecoil) RecoilStrength *= 0.666;
 if (bSpecRange)
 {
  MaxRange *= 1.5;
  AccurateRange *= 1.5;
 } 
}

defaultproperties
{
     ProjectileNames(1)=class'MSC20mmCannister'
     BaseAccuracy=0.000000
     LowAmmoWaterMark=30
     GoverningSkill=Class'DeusEx.SkillWeaponRifle'
     NoiseLevel=2.000000
     EnviroEffective=ENVEFF_Air
     ShotTime=0.200000
     reloadTime=1.000000
     HitDamage=8
     maxRange=24000
     AccurateRange=14400
     bCanHaveScope=True 
     bHasScope=False
     bHasMuzzleFlash=True
     recoilStrength=1.000000
     bUseWhileCrouched=True
     AmmoName=Class'DeusEx.Ammo10mm'
     ReloadCount=4
     PickupAmmoCount=80
     FireOffset=(X=0.000000,Y=0.000000,Z=0.000000)
     shakemag=25.000000
     FireSound=None
     CockingSound=None
     SelectSound=None
     AltFireSound=None
     InventoryGroup=255
     ItemName="Custom Built Weapon"
     PlayerViewOffset=(X=0.000000,Y=0.000000,Z=-80.000000)
     PlayerViewMesh=LodMesh'DeusExItems.GEPGun'
     PickupViewMesh=LodMesh'DeusExItems.GEPGunPickup'
     ThirdPersonMesh=LodMesh'DeusExItems.GEPGun3rd'
     LandSound=Sound'DeusExSounds.Generic.DropSmallWeapon'
     Icon=Texture'CustomWeaponIcon'
     largeIcon=Texture'CustomWeaponIcon'
     largeIconWidth=48
     largeIconHeight=48
     invSlotsX=1
     invSlotsY=1
     Description="A gun you customized yourself, or so I'd hope."
     beltDescription="|p4Custom Gun"
     Mesh=LodMesh'DeusExItems.GEPGunPickup'
     CollisionRadius=15.000000
     CollisionHeight=5.600000
     Mass=10.000000
     Texture=Texture'ReflectionMapTex2'
     bInstantHit=True
     ViewOffsets(1)=(X=16.000000,Y=5.000000,Z=-11.500000)
     ViewOffsets(2)=(X=24.000000,Y=10.000000,Z=-14.000000)
     ViewOffsets(3)=(X=30.000000,Y=10.000000,Z=-12.000000)
     ViewOffsets(4)=(X=22.000000,Y=10.000000,Z=-14.000000)
     ViewOffsets(5)=(X=11.000000,Y=4.000000,Z=-13.000000)
     ViewOffsets(6)=(X=20.000000,Y=2.000000,Z=-30.000000)
     ViewOffsets(7)=(X=25.000000,Y=15.000000,Z=-26.500000)
     ViewOffsets(8)=(X=20.000000,Y=7.000000,Z=-12.000000)
     FireOffsets(1)=(X=-16.000000,Y=-5.000000,Z=11.500000)
     FireOffsets(2)=(X=-24.000000,Y=-10.000000,Z=14.000000)
     FireOffsets(3)=(X=-30.000000,Y=-10.000000,Z=12.000000)
     FireOffsets(4)=(X=-22.000000,Y=-10.000000,Z=14.000000)
     FireOffsets(5)=(X=-11.000000,Y=-4.000000,Z=13.000000)
     FireOffsets(6)=(X=-20.000000,Y=-2.000000,Z=30.000000)
     FireOffsets(7)=(X=-25.000000,Y=-15.000000,Z=29.500000)
     FireOffsets(8)=(X=-20.000000,Y=-7.000000,Z=12.000000)
}
